/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.indication.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.snia.wbemcfg.GlobalConfig;

public class HSCSocket {
    private static final int SOCKET_NOT_USED = 0;
    private static final int SOCKET_IN_READING = 1;
    private static final int SOCKET_IN_WRITING = 2;
    private static final String ERROR_READ_OBJ = "Read object failed. \n";
    private static final int NO_BLOCK_READ_TIME_OUT = 10;
    private static final int NO_BLOCK_WRITE_TIME_OUT = 8000;
    public static final int SERVER_SOCKET_PORT = 9197;
    protected Socket mSocket;
    protected InputStream mSIs;
    protected ObjectInputStream mIs;
    protected ObjectOutputStream mOs;
    protected boolean mNoBlock;
    protected boolean mUsingSSL = false;

    public HSCSocket(Socket socket, boolean bl) throws IOException {
        this.mSocket = socket;
        if (GlobalConfig.SocketProvider.indexOf("PKCS12") >= 0) {
            System.out.println("SocketProvider=PKCS12");
            this.mUsingSSL = true;
        }
        this.mOs = new ObjectOutputStream(socket.getOutputStream());
        this.mSIs = socket.getInputStream();
        this.createObjectInputStream();
        this.mNoBlock = bl;
        if (this.mNoBlock) {
            this.mSocket.setSoTimeout(8000);
        }
    }

    protected void createObjectInputStream() throws IOException {
        this.mIs = new ObjectInputStream(this.mSIs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object readObject() throws IOException {
        if (this.mNoBlock) {
            int n = 0;
            HSCSocket hSCSocket = this;
            synchronized (hSCSocket) {
                try {
                    if (this.mSocket == null) {
                        Object var3_5 = null;
                        return var3_5;
                    }
                    this.mSocket.setSoTimeout(10);
                    n = this.mSIs.available();
                }
                catch (InterruptedIOException interruptedIOException) {
                    Object var4_7 = null;
                    return var4_7;
                }
                finally {
                    this.mSocket.setSoTimeout(8000);
                }
            }
            if (n < 2) {
                if (n == 1 && this.mUsingSSL) {
                    this.mSIs.skip(1L);
                }
                return null;
            }
        }
        try {
            if (this.mNoBlock) {
                Socket socket = this.mSocket;
                synchronized (socket) {
                    return this.mIs.readObject();
                }
            }
            return this.mIs.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace(System.out);
            this.mIs.reset();
            throw new RuntimeException(ERROR_READ_OBJ + classNotFoundException.getMessage());
        }
    }

    public synchronized void writeObject(Object object) throws IOException {
        if (this.mSocket == null) {
            return;
        }
        this.mOs.writeObject(object);
        this.mOs.flush();
        this.mOs.reset();
    }

    public void close() throws IOException {
        this.mSocket.close();
        this.mOs = null;
        this.mIs = null;
        this.mSocket = null;
    }
}

